/* PROGRAMME EMETTEUR BIPSE2 
 
    pour carte Arduino pro mini 5V/16MHz
    sorties à connecter à un circuit de puissance L6203
    fréquence d'émission 3200Hz
    1 bip par seconde doublé tous les 4 bips
    durée du bip: 80ms
    gestion du marche/arret
    avec arret automatique quand la tension batterie atteint 18,5V
    *  A la mise sous tension des bips renseignenet sur l'état de charge de la batterie
 *                            4 bips charge>90%
 *                            3 bips 75%<charge<90%
 *                            2 bips 50%<charge<75%
 *                            1 bip 25%<charge<50%
   auteur Joan ERRA, licence creative common CC BY NC Attribution non commerciale
     */
#define led 7 // led intégré au bouton poussoir
#define in1 10  // sortie signal 3200Hz
#define in2 9  // sortie signal 3200Hz
#define enable 8 // sortie rythme des bip-bip
#define buzzer A3
#define kBATT A0 // tension image de la tension batterie k=0,163
#define bp_on 2 // Bouton poussoir
#define on A2 // commande bobine d'enclenchement du relais
#define off A1 // commande bobine de déclenchement du relais

//pont diviseur sur Vbat réglé avec P1 pour avoir un rapport de division de 0,163 
// c'est à dire pour Vbat=18,5V on aura 3,02V
//NBATT=33,43Vbat
#define NBAT0 618 //correspond à kBATT=3,02V soit VBATT=18,5V, déchargé
#define NBAT1 748 //correspond à VBATT=22,39V (3,7V par élément), 25%<charge<50% 
#define NBAT2 762 //correspond à VBATT=22,8V (3,8V par élément), 50%<charge<75%
#define NBAT3 782 //correspond à VBATT=23,4V (3,9V par élément) 75%<charge<90%
#define NBAT4 800 //correspond à VBATT=23,9V (4V par élément), charge>90%


char pret_pour_arret = 0; //à la mise sous tension l' aooui sur le poussoir
                          // ne doit pas arrêter le fonctionnement
void setup()
{
  Serial.begin(9600);
  pinMode(in1, OUTPUT);
  pinMode(in2, OUTPUT);
  pinMode(led, OUTPUT);
  pinMode(buzzer, OUTPUT);
  pinMode(enable, OUTPUT);
  pinMode(on, OUTPUT);
  pinMode(off, OUTPUT);

  ouvrir_contact();// ouvre le contact du relais
  delay(100);
  /* le timer fourni en permanence 2 signaaux rectangulaires
      en opossition de phase
       in1 et in2 à 3200Hz
  */
  // Timer/Counter 1 initialization
  // Clock source: System Clock
  // Clock value: 16000,000 kHz
  // Mode: CTC top=OCR1A
  // OC1A output: Toggle on compare match
  // OC1B output: Toggle on compare match
  // Noise Canceler: Off
  // Input Capture on Falling Edge
  // Timer Period: 0,15625 ms
  // Output Pulse(s):
  // OC1A Period: 0,3125 ms Width: 0,15625 ms
  // OC1B Period: 0,3125 ms Width: 0,15625 ms
  // Timer1 Overflow Interrupt: Off
  // Input Capture Interrupt: Off
  // Compare A Match Interrupt: Off
  // Compare B Match Interrupt: Off
  TCCR1A = (0 << COM1A1) | (1 << COM1A0) | (0 << COM1B1) | (1 << COM1B0) | (0 << WGM11) | (0 << WGM10);
  TCCR1B = (0 << ICNC1) | (0 << ICES1) | (0 << WGM13) | (1 << WGM12) | (0 << CS12) | (0 << CS11) | (1 << CS10);

  TCNT1H = 0x00;
  TCNT1L = 0x00;
  ICR1H = 0x00;
  ICR1L = 0x00;
  OCR1AH = 0x09;
  OCR1AL = 0xC3;
  OCR1BH = 0x00;
  OCR1BL = 0x0E;
  // Timer/Counter 1 Interrupt(s) initialization
  TIMSK1 = (0 << ICIE1) | (0 << OCIE1B) | (0 << OCIE1A) | (0 << TOIE1);
  digitalWrite(in2, 1); //;permettra d'avoir l'opposition de phase avec in1

  // initialiastion d'interruption quand on relache le bouton poussoir
  attachInterrupt(digitalPinToInterrupt(bp_on), arreter, RISING);
  
  // confirmer sous tension si la tension batterie dépasse Vbatmini=18,5V
  if (analogRead(kBATT) > NBAT0)fermer_contact();
  else 
    {
      ouvrir_contact();
      //attendre que le condo de filtrage d'alim se décharge
      while (1);
    }
  digitalWrite(buzzer,1);
  delay(200);
  digitalWrite(buzzer,0);
  //a partir de là, l'arret sera possible par appui sur le poussoir
  pret_pour_arret = 1;
 
  //attendre que le poussoir soit relaché
  while(digitalRead(bp_on)==1);
  delay(3000);
  test_etat_batterie();//faire des bips en fonction état de charge de la batterie
}

void loop()
{
  // tant que la tension de la batterie est suffisante
  // envoyer des bip-bip
  while (analogRead(kBATT) > NBAT0)
  {

    // générer 3 bips espacés de 1s
    for (int i = 0; i < 3; i++)
    {
      digitalWrite(led, 1);
      digitalWrite(enable, 1);
      digitalWrite(buzzer, 1);
      for (int i = 0; i < 80; i++)delayMicroseconds(1000); // générateion du signal pendant 80ms
      digitalWrite(enable, 0);
      digitalWrite(buzzer, 0);
      digitalWrite(led, 0);
      for (int i = 0; i < 920; i++)delayMicroseconds(1000); //temps mort de 920ms
    }
    // générer 2 bips espécés de 100ms
    for (int i = 0; i < 2; i++)
    {
      digitalWrite(led, 1);
      digitalWrite(enable, 1);
      digitalWrite(buzzer, 1);
      for (int i = 0; i < 80; i++)delayMicroseconds(1000); // générateion du signal pendant 80ms
      digitalWrite(enable, 0);
      digitalWrite(buzzer, 0);
      digitalWrite(led, 0);
      for (int i = 0; i < 100; i++)delayMicroseconds(1000);
    }
    //a partir de là, l'arret sera possible par appui sur le poussoir
    pret_pour_arret = 1;
    //if (digitalRead(bp_on)==1)arreter();
    for (int i = 0; i < 820; i++)delayMicroseconds(1000);
  }

  // ici la tension batterie n'est plus suffisante
  // on ouvre le contact ce qui met hors tension l'emetteur
  ouvrir_contact();
  //attendre que le condo de filtrage d'alim se décharge
  while (1);
}

////F: mettre hors tension l'émetteur suite à impulsion sour le bouton poussoir//////
void arreter()
{
  if (pret_pour_arret == 1)
  {
    digitalWrite(buzzer, 1);
    for (int i = 0; i < 1000; i++)delayMicroseconds(1000); // bip de 80ms
    digitalWrite(buzzer, 0);
    ouvrir_contact();
    //attendre que le condo de filtrage d'alim se décharge
    while (1);
  }
  // on ne fait rien, car pas encore prêt pour être arréter par le poussoir
  //ce qui est le cas au relachement du poussoir à la mise en route  de la balise.
}

/////F:  mettre sous tension///////////////////////////////////////////////////////
void fermer_contact()
{
  // on va s'assurer que la bobine émettrice n'est pas alimentée
  digitalWrite(enable, 0);
  // on envoie une impulsion sur la bobine de "on" du relais bistable
  digitalWrite(off, 0);
  digitalWrite(on, 1);
  for (int i = 0; i < 30; i++)delayMicroseconds(1000); // durée impulsion 30ms
  digitalWrite(on, 0);
}

/////F: mettre hors tension///////////////////////////////////////////////////////
void ouvrir_contact()
{
  // ouvrir le contact , si le poussoir est relaché
  //revient à débrancher l'alimentation

  // on va s'assurer que la bobine émettrice n'est pas alimentée
  digitalWrite(enable, 0);
  // on envoie une impulsion sur la bobine de "off" du relais bistable
  digitalWrite(on, 0);
  digitalWrite(off, 1);
  for (int i = 0; i < 30; i++)delayMicroseconds(1000); // durée impulsion 30ms
  digitalWrite(off, 0);
}

/////F:faire des bips en fonction état de charge de la batterie//////////////////////////////////
void test_etat_batterie()
{
  if (analogRead(kBATT) >= NBAT4 )
  { // faire 4 bips
    for (int i = 0; i < 4; i++)
    {
      digitalWrite(buzzer, 1);
      delay(3000);
      digitalWrite(buzzer, 0);
      delay(1000);
    }
  }

  if (analogRead(kBATT) >= NBAT3 and analogRead(kBATT) < NBAT4)
  { // faire 3 bips
    for (int i = 0; i < 3; i++)
    {
      digitalWrite(buzzer, 1);
      delay(3000);
      digitalWrite(buzzer, 0);
      delay(1000);
    }
  }
  if (analogRead(kBATT) >= NBAT2 and analogRead(kBATT) < NBAT3)
  { // faire 2 bips
    for (int i = 0; i < 2; i++)
    {
      digitalWrite(buzzer, 1);
      Serial.println(analogRead(kBATT));
      delay(3000);
      digitalWrite(buzzer, 0);
      delay(1000);
    }
  }

  if (analogRead(kBATT) >= NBAT1 and analogRead(kBATT) < NBAT2)
  { // faire 1 bip
    digitalWrite(buzzer, 1);
    delay(3000);
    digitalWrite(buzzer, 0);
    delay(1000);
  }
}
